
/*++
INTEL CONFIDENTIAL
Copyright 2005-2015 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.
--*/


/*
File Name:
   Fwu_Common.h
Abstract:
   Definitions for the Fw Update Kernel Service.
Author
   Kingsley Adeoye
*/


#ifndef _FWU_COMMON_H
#define  _FWU_COMMON_H

#include "ver.h"
#include "mkhi_hdrs.h"

typedef unsigned int STATUS;

//#define     FW_UPDATE_STATUS           unsigned int

#define BLACK_LIST_ENTRY_MAX           10
#define FWU_PWD_MAX_SIZE               32
#define MAXIMUM_IPU_SUPPORTED          4
#define ACTUAL_IPU_SUPPORTED           3
#define HASH_SHA256_LEN                32

#define FPT_PARTITION_NAME_UPDT 0x54445055
#define FPT_PARTITION_NAME_ISHC 0x43485349

// Safe Update States
#define         SU_STATE0_NO_UPDATE                         0  
#define         SU_STATE1_COPY_FT_TO_NFTP_BEGIN             1
#define         SU_STATE1_COPY_FT_TO_NFTP_END               2
#define         SU_STATE2_COPY_ALL_BEGIN                    3
#define         SU_STATE2_COPY_ALL_END                      4
#define         SU_STATE3_CONFIRM_LIVE_PING_BEGIN           5
#define         SU_STATE3_CONFIRM_LIVE_PING_END             6
#define         SU_ROLLBACK1_RECOVER_NFT_BEGIN              7
#define         SU_ROLLBACK1_RECOVER_NFT_END                0           // Back to NO_UPDATE
#define         SU_ROLLBACK2_RECOVER_ALL_BEGIN              8
//#define         SU_FORCE_ROLLBACK2_RECOVER_ALL              9
#define         SU_ROLLBACK2_RECOVER_ALL_END                0           // Back to NO_UPDATE

// From FwuHeciMsgs.h
/* HMRFPO_GETSTATUS_CMD_STATUS and HMRFPOState Values*/
#define     HMRFPO_DISABLED 0
#define     HMRFPO_LOCKED   1
#define     HMRFPO_ENABLED  2

/** \addtogroup fwupdate 
  <b>HMRFPO_ENABLE</b> Data structure: 
  \li \ref _FWUPDATE_HMRFPO_ENABLE_DATA
  \li \ref _FWUPDATE_HMRFPO_ENABLE
  \li \ref _FWUPDATE_HMRFPO_ENABLE_ACK_DATA
  \li \ref _FWUPDATE_HMRFPO_ENABLE_ACK  
*/ 
 
// ***************************************
/* HMRFPO Related Enums                 */
// ***************************************
/** \addtogroup fwupdate 
  HMRFPO_ENABLE_CMD_ACK_STATUS codes: 
  \code 
     #define     HMRFPO_ENABLE_SUCCESS     0
     #define     HMRFPO_LOCKED             1
     #define     HMRFPO_NVAR_FAILURE       2
     #define     HMRFPO_TDT_FAILURE        3
     #define     HMRFPO_EOP_FAILURE        4
     #define     HMRFPO_ENABLE_UNKNOWNFAIL 5
  \endcode
*/

/* HMRFPO_ENABLE_CMD_ACK_STATUS */
#define     HMRFPO_ENABLE_SUCCESS     0
#define     HMRFPO_LOCKED             1
#define     HMRFPO_NVAR_FAILURE       2
#define     HMRFPO_TDT_FAILURE        3
#define     HMRFPO_EOP_FAILURE        4
#define     HMRFPO_ENABLE_UNKNOWNFAIL 5


/** \addtogroup fwupdate 
   <b>HMRFPO_LOCK</b> Data structure: 
  \li \ref _FWUPDATE_HMRFPO_LOCK
  \li \ref _FWUPDATE_HMRFPO_LOCK_ACK_DATA
  \li \ref _FWUPDATE_HMRFPO_LOCK_ACK 
*/ 

/** \addtogroup fwupdate 
  HMRFPO_LOCK_CMD_ACK_STATUS codes: 
  \code 
   #define     HMRFPO_LOCK_SUCCESS         0
   #define     HMRFPO_LOCK_MANUF_MODE_FAIL 1
  \endcode
*/

/* HMRFPO_LOCK_CMD_ACK_STATUS */
#define     HMRFPO_LOCK_SUCCESS     0
#define     HMRFPO_LOCK_MANUF_MODE_FAIL 1

#if 1
/**
 * @brief The operation completed successfully.
 */
#define STATUS_SUCCESS                0x0

//
//STATUS_SIZE_ERROR
//    The size of the specified object (memory pool, stack, message queue, 
//    etc.) is invalid. 
//
#define STATUS_SIZE_ERROR             0x5

//
//STATUS_NOT_AVAILABLE
//    An attempt to remove a mutex on which a thread is suspended has been 
//    attempted.
// 
#define STATUS_NOT_AVAILABLE          0x1D

//
//STATUS_NOT_FOUND
//    The requested item could not be found.
// 
#define STATUS_NOT_FOUND              0x81

//
//STATUS_INVALID_HANDLE
//    The provided handle does not exist.
//
#define STATUS_INVALID_HANDLE         0x83

//
//STATUS_INVALID_ACCESS
//    An attempt was made to access an inaccessible or unavailable object.
//
#define STATUS_INVALID_ACCESS         0x84

//
//STATUS_INVALID_PARAMS
//    One or more parameters are invalid.
// 
#define STATUS_INVALID_PARAMS         0x85

//
//STATUS_NOT_READY
//    The h/w device is not ready.
// 
#define STATUS_NOT_READY              0x88

//
//STATUS_NOT_SUPPORTED
//    The function, message or request is not recognized or supported.
// 
#define STATUS_NOT_SUPPORTED          0x89

//
//STATUS_DEVICE_ERROR
//    The h/w device reported an error while attempting the operation.
// 
#define STATUS_DEVICE_ERROR           0x8B

//
//STATUS_INVALID_ADDRESS
//    The address provided in invalid.
// 
#define STATUS_INVALID_ADDRESS        0x8C

//
//STATUS_INVALID_COMMAND
//    The requested command is unrecognized or invalid.
// 
#define STATUS_INVALID_COMMAND        0x8D

//
//STATUS_STACK_OVERFLOW 
//    The request caused a stack overflow.
//
#define STATUS_STACK_OVER_FLOW        0x8E

//
//STATUS_BUFFER_TOO_SMALL
//    The provided buffer is too small to hold the requested data.
// 
#define STATUS_BUFFER_TOO_SMALL       0x8F

//
//STATUS_INVALID_BUFFER 
//    The buffer was not the proper size for the request.
//
#define STATUS_INVALID_BUFFER         0x91

//
//STATUS_NO_RESPONSE
//    No response was received from the requested target.
// 
#define STATUS_NO_RESPONSE            0x92

//
//STATUS_TIMED_OUT
//    The device or object timed out and was unable to complete the request.
// 
#define STATUS_TIMED_OUT              0x93

// 
//STATUS_NOT_STARTED
//    The requested operation could not be started.  For protocols, this 
//    error indicates the protocol has not been started.
//
#define STATUS_NOT_STARTED            0x94

//
//STATUS_ALREADY_STARTED
//    The requested operation has already been started.  
//    - For protocols, this error 
//    indicates the protocol has already been started.  
//    - For Policy Manager this error means
//    that the MKHI group ID is already registered.
//    For FW update, we only allow one process to do the update at a time, this means error
//    case where FW update is already in progress, the current process will have to try later.
// 
#define STATUS_ALREADY_STARTED        0x95

//
//STATUS_OUT_OF_RESOURCES
//    Insufficient resources to perform the request. Used by components operating
//    in non-blocking mode. A caller will be returned this error when a component
//    does not have enough resources like command buffers, PRDs etc... to entertain
//    a new request.
//
#define STATUS_OUT_OF_RESOURCES       0x9D

//
//STATUS_FAILURE
//    A unknown error encountered while performing a requested transaction.
//
#define STATUS_FAILURE                0x9E

//
//STATUS_IMAGE_INVALID
//    The FW Update image content is invalid.
#define STATUS_IMAGE_INVALID           0xA5

// STATUS_UPDATE_MISMATCH_HW_SKU 
//    Indicates that there is a mismatch between the current HW SKU and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_HW_SKU  0xB6

// STATUS_UPDATE_MISMATCH_FW_SKU 
//    Indicates that there is a mismatch between the current FW SKU and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_FW_SKU  0xB7

// STATUS_UPDATE_MISMATCH_VERSION 
//    Indicates that there is a mismatch between the current FW version and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_VERSION 0xB8

//
//STATUS_OUT_OF_MEMORY
//    This error can be returned for the following reasons: 
//       1.Attempt to allocate memory and no memory is available
//       2.Attempt to free a memory block on which a thread is suspended
//    NOTE: This value is the same a as STATUS_START_ERROR.
// 
#define STATUS_OUT_OF_MEMORY              0xBE

// STATUS for FWU kernel between  0x200  to 0x2FF
#define FW_UPDATE_STATUS UINT32

#define   NO_UPDATE  0
#define   STATUS_UPDATE_SUCCESS                                               0x0   // Zero for sucess anything else is consider failures 
#define   STATUS_UPDATE_IMAGE_INVALID                                         0x201
#define   STATUS_UPDATE_INTEGRITY_FAILURE                                     0x202
#define   STATUS_UPDATE_SKU_MISMATCH                                          0x203
#define   STATUS_UPDATE_FW_VERSION_MISMATCH                                   0x204    
#define   STATUS_UPDATE_GENERAL_FAILURE                                       0x205    
#define   STATUS_UPDATE_OUT_OF_RESOURCES                                      0x206    
#define   STATUS_UPDATE_AUDIT_POLICY_FAILURE                                  0x207
#define   STATUS_UPDATE_ERROR_CREATING_FT                                     0x208
#define   STATUS_UPDATE_SAL_NOTIFICATION_ERROR                                0x209
#define   STATUS_UPDATE_IMG_LOADING                                           0x20A
#define   STATUS_UPDATE_IMG_AUTHENTICATING                                    0x20B
#define   STATUS_UPDATE_IMG_PROCESSING                                        0x20C
#define   STATUS_UPDATE_CREATING_FT                                           0x20D
#define   STATUS_UPDATE_UPDATING_CODE                                         0x20E
#define   STATUS_UPDATE_UPDATING_NFT                                          0x20F
#define   STATUS_UPDATE_FLASH_CODE_PARTITION_INVALID                          0x210
#define   STATUS_UPDATE_FLASH_NFT_PARTITION_INVALID                           0x211
#define   STATUS_UPDATE_ILLEGAL_IMAGE_LENGTH                                  0x212
#define   STATUS_UPDATE_NOT_READY                                             0x213
                                                                              
#define   STATUS_UPDATE_HOST_RESET_REQUIRED                                   0x214
#define   STATUS_INVALID_GLUT                                                 0x215
#define   STATUS_INVALID_OEM_ID                                               0x216
                                                                              
// New for CPT add below here                                                 
#define   STATUS_UPDATE_IMAGE_BLACKLISTED                                     0x217	   //New SPT
#define   STATUS_UPDATE_IMAGE_VERSION_HISTORY_CHECK_FAILURE                   0x218	   //New SPT
#define   STATUS_UPDATE_DOWNGRADE_VETOED                                      0x219
#define   STATUS_UPDATE_WRITE_FILE_FAILURE                                    0x22A
#define   STATUS_UPDATE_READ_FILE_FAILURE                                     0x22B
#define   STATUS_UPDATE_DELETE_FILE_FAILURE                                   0x22C
#define   STATUS_UPDATE_PARTITION_LAYOUT_NOT_COMPATIBLE                       0x22D    // FW Update is not possible due to partition move //New SPT - partition sizes
#define   STATUS_DOWNGRADE_NOT_ALLOWED_DATA_MISMATCHED                        0x22E
#define   STATUS_UPDATE_FW_UPDATE_IS_DISABLED                                 0x22F
#define   STATUS_UPDATE_PASSWORD_NOT_MATCHED                                  0x230
#define   STATUS_UPDATE_PASSWORD_EXCEED_MAXIMUM_RETRY                         0x231
#define   STATUS_UPDATE_INRECOVERY_MODE_RESTRICT_UPDATE_TO_ATTEMPTED_VERSION  0x232    // They have to update with the same image that they started with.


// New for Partial FW update
#define   STATUS_UPDATE_UPV_VERSION_MISMATCHED                                0x233    // UPV version mismatched update is not allow
#define   STATUS_UPDATE_INSTID_IS_NOT_EXPECTED_ID                             0x234    // Reject update, instance ID sent is not one of expected ID
#define   STATUS_UPDATE_INFO_NOT_AVAILABLE                                    0x235    // While in the middle of update IPU attrib info will bot be available
#define   STATUS_UPDATE_REJ_IPU_FULL_UPDATE_NEEDED                            0x236    // Can't do IPU update while we are in Full recovery mode.
#define   STATUS_UPDATE_IPU_NAMEID_NOT_FOUND                                  0x237    // IPU name not found when compare with UPV extension

#define   STATUS_UPDATE_RESTORE_POINT_INVALID                                 0x238
#define   STATUS_UPDATE_RESTORE_POINT_VALID_BUT_NOT_LATEST                    0x239
#define   STATUS_UPDATE_RESTORE_POINT_OPERATION_NOT_ALLOWED                   0x23A
#define   STATUS_DOWNGRADE_NOT_ALLOWED_SVN_RESTRICTION                        0x23B
#define   STATUS_DOWNGRADE_NOT_ALLOWED_VCN_RESTRICTION                        0x23C
#define   STATUS_INVALID_SVN												  0x23D
#define   STATUS_UPDATE_OUT_OF_SVN_RESOURCES								  0x23E
#define   STATUS_UPDATE_REJECT_RESTORE_POINT_REQUEST_FLASH_IN_RECOVERY   	  0x23F
#define   STATUS_UPDATE_REJECTED_BY_UPDATE_POLICY                             0x240
#define   STATUS_UPDATE_REJECTED_INCOMPATIBLE_TOOL_USAGE                      0x241
#define   STATUS_UPDATE_REJECTED_CROSSPOINT_UPDATE_NOT_ALLOWED                0x242
#define   STATUS_UPDATE_REJECTED_CROSSHOTFIX_UPDATE_NOT_ALLOWED               0x243
#define   STATUS_UPDATE_REJECTED_CURRENT_FW_NOT_ELIGIBLE_FOR_UPDATE           0x244
#define   STATUS_UPDATE_REJECTED_WRONG_UPDATE_OPERATION                       0x245
#define   STATUS_UPDATE_REJECTED_WRONG_UPDATE_IMAGE_FOUND                     0x246
#define   STATUS_UPDATE_REJECTED_IFR_UPDATE_NOT_ALLOWED                       0x247
#define   STATUS_UPDATE_FAILURE_OCCURRED_DURING_ROLLBACK                      0x248

// New for SPT add below here
#define	  STATUS_UPDATE_FW_ENGINEERING_VERSION_NOT_ALLOWED					  0x249
#define   STATUS_UPDATE_FW_ENGINEERING_VERSION_REQUIRED						  0x24A
#define   STATUS_UPDATE_FW_RESTORE_HISTORY_NOT_FOUND						  0x24B
#define	  STATUS_UPDATE_API_VERSION_MISMATCH								  0x24C


//.........................................................................
//.........................................................................            // Reserve for FWU usage
#define   STATUS_UPDATE_LAST_STATUS_CODE                                      0x2FF 

// means internal FW operation errors 
//#define   STATUS_UPDATE_UNKNOWN = 0xFFFFFFFF


#endif


#pragma pack(1)
// From FwuHeciMsgs.h
// MKHI CMD Defs
typedef enum 
{
   FWUPDATE_HMRFPO_ENABLE_CMD = 0x01,
   FWUPDATE_HMRFPO_LOCK_CMD,
   FWUPDATE_HMRFPO_GETSTATUS_CMD,
   FWUPDATE_HMRFPO_DISABLE_CMD,
   FWU_GET_IMAGE_FW_VERSION_CMD, 

   FWUPDATE_HMRFPO_ENABLE_CMD_ACK = 0x81,
   FWUPDATE_HMRFPO_LOCK_CMD_ACK,
   FWUPDATE_HMRFPO_GETSTATUS_CMD_ACK,
   FWUPDATE_HMRFPO_DISABLE_CMD_ACK,
   FWU_GET_IMAGE_FW_VERSION_CMD_ACK

} FWUPDATE_HMRFPO_MKHI_COMMANDS;

// ***************************************
/* Fixed address MKHI FWUPDATE messaging commands Group ID 0x06 for FW update*/
// ***************************************
typedef enum 
{
   FWUPDATE_RESUME_CMD = 0x01,
   FWUPDATE_QUERY_STATUS_CMD,
   FWUPDATE_FORCE_SAFE_BOOT_CMD,

   FWUPDATE_RESUME_CMD_ACK = 0x81,
   FWUPDATE_QUERY_STATUSCMD_ACK,
   FWUPDATE_FORCE_SAFE_BOOT_ACK,

} FWUPDATE_MKHI_COMMANDS;

// From MeTypes.h
// Enums for the FLASH image possible states and Update states.
//
typedef enum _FLASH_IMAGE_STATUS
{
   IMAGE_VALID = 0,
   IMAGE_CODE_INVALID,
   IMAGE_NFT_INVALID,
   IMAGE_CREATING_FT,    // Make backup of FT, or copy FT to NFTP partition for IFR
   IMAGE_UPDATING_CODE,
   IMAGE_UPDATING_NFT,

   IMAGE_STATUS_UNKNOWN = 0xFFFFFFFF

} FLASH_IMAGE_STATUS;

typedef enum _FWU_HECI_MSG_STATUS{
      FWU_NOT_READY,
      FWU_ILLEGAL_LENGTH, //allocate image buffer
} FWU_HECI_MSG_STATUS;

typedef enum _BLACK_LIST_EXPRESSION_TYPES
{
   BLE_EMPTY = 0,
   BLE_EQ,
   BLE_LTE,
   BLE_GTE,
   BLE_RANGE
}BLACK_LIST_EXPRESSION_TYPES;

typedef enum _FWU_OPERATION
{
   FWU_FULL_UPDATE_OPERATION   =   0,
   FWU_IPU_UPDATE_OPERATION
}FWU_OPERATION;

typedef enum _FWU_ENVIRONMENT
{
   FWU_ENV_MANUFACTURING = 0,   // Manufacturing update
   FWU_ENV_IFU,                 // Independent Firmware update
}FWU_ENVIRONMENT;

typedef enum _FWU_ROLLBACK_MODE
{
   FWU_ROLLBACK_NONE = 0,       // No rollback
   FWU_ROLLBACK_1,              // Rollback 1 procedure
   FWU_ROLLBACK_2,              // Rollback 2 procedure
}FWU_ROLLBACK_MODE;

typedef struct _FWU_INFO_FLAGS
{
   unsigned int RecoveryMode:2;   // 0 = No recovery; 1 = Full Recovery Mode,2 = Partial Recovery Mode
   unsigned int IpuNeeded:1;      // IPU_NEEDED bit, if set we are in IPU_NEEDED state.
   unsigned int FwInitDone:1;     // If set indicate FW is done initialized
   unsigned int FwuInProgress:1;  // If set FWU is in progress, this will be set for IFU update as well
   unsigned int SuInprogress:1;   // If set IFU Safe FW update is in progress. 
   unsigned int NewFtTestS:1;     // If set indicate that the new FT image is in Test Needed state (Stage 2 Boot)
   unsigned int SafeBootCnt:4;    // Boot count before the operation is success
   unsigned int FsbFlag:1;        // Force Safe Boot Flag, when this bit is set, we'll boot kernel only and go into recovery mode	

   //////////////////////////////////////////////////////
   // These fields below are important for FWU tool. 
   //////////////////////////////////////////////////////
   unsigned int LivePingNeeded:1;     // Use for IFU only, See Below  
                                // FWU tool needs to send Live-Ping or perform querying to confirm update successful.
                                // With the current implementation when LivePingNeeded is set, 
                                // Kernel had already confirmed it. No action from the tool is needed.
   unsigned int ResumeUpdateNeeded:1; // Use for IFU only, If set FWU tool needs to resend update image
   unsigned int RollbackNeededMode:2; // FWU_ROLLBACK_NONE = 0, FWU_ROLLBACK_1, FWU_ROLLBACK_2 
                                // If not FWU_ROLLBACK_NONE, FWU tool needs to send restore_point image. 
   unsigned int ResetNeeded:2;        // When this field is set to ME_RESET_REQUIRED, FW Kernel will
                                // perform ME_RESET after this message. No action from the tool is needed.
   unsigned int SuState:4;		    // See possible values below
   unsigned int RecoveryCause:2;      // IMAGE_CODE_INVALID = 1; IMAGE_NFT_INVALID = 2;
   unsigned int Reserve:8;
}FWU_INFO_FLAGS;


typedef struct    _BLACK_LIST_ENTRY
{
   unsigned short   ExpressionType;
   unsigned short   MinorVer;
   unsigned short   HotfixVer1;
   unsigned short   BuildVer1;
   unsigned short   HotfixVer2;
   unsigned short   BuildVer2;
}BLACK_LIST_ENTRY;


//Data
typedef struct _FWU_HECI_MESSAGE_DATA
{
   unsigned int   Length;
   unsigned char    Reserved[3];
   unsigned char    Data[1];
} FWU_HECI_MESSAGE_DATA;


typedef struct _PT_ATTRB
{
   unsigned int   PtNameId;      // HW_COMP_HDR_STRUCTID_WCOD     0x244f4357 OR 
                           // HW_COMP_HDR_STRUCTID_LOCL     0x4C434F4C OR
                           // HW_COMP_HDR_STRUCTID_MDMV     0x564D444D 
   unsigned int   LoadAddress;         // Load Address of the IPU
   VERSION  FwVer;         // FW version from IUP Manifest
   unsigned int   CurrentInstId; // Current Inst ID from flash, 0 indicate invalid ID 
   unsigned int   CurrentUpvVer; // Upper sig 16 bits are Major Version.
   unsigned int   ExpectedInstId;// Expected Inst ID that need to be updated to
   unsigned int   ExpectedUpvVer;// Upper sig 16 bits are Major Version.
   unsigned int   Resv[4];
}PT_ATTRB;
C_ASSERT(sizeof(PT_ATTRB) == 48);


typedef struct _RESTORE_POINT_IPU_ATTR
{
    unsigned int   PartitionId;           // WCOD, LOCL, MDMV
    VERSION  FwVer;                 // FW version from IUP Manifest
    unsigned int   CurrentInstId;         // Current Inst ID from flash, 0 indicate invalid ID 
    unsigned int   CurrentUpvVer;         // Upper sig 16 bits are Major Version.
}RESTORE_POINT_IPU_ATTR;
C_ASSERT(sizeof(RESTORE_POINT_IPU_ATTR) == 20);


typedef struct _OEM_UUID
{
   unsigned int Data1;
   unsigned short Data2;
   unsigned short Data3;
   unsigned char Data4 [ 8 ];
} OEM_UUID;


typedef struct _FWU_RESTORE_POINT_INFO
{
    unsigned char           HashCalculated[HASH_SHA256_LEN];
    VERSION  FwVer; // FT Firmware version
    RESTORE_POINT_IPU_ATTR RestAttr[ACTUAL_IPU_SUPPORTED];
    unsigned int          RESERVE;
}FWU_RESTORE_POINT_INFO;
C_ASSERT(sizeof(FWU_RESTORE_POINT_INFO) == 104);


typedef struct _UPDATE_VERSION_INFO
{
   VERSION  Version;
   unsigned char    History[4];
   unsigned int   CriticalHotfixDescriptor;

}UPDATE_VERSION_INFO;


typedef struct _UPDATE_FLAGS
{
   unsigned int RestorePoint:1;           // If set indicate restore point 
   unsigned int RestartOperation:1;       // If set indicate restart operation, like lost hard drive etc...
   unsigned int UserRollback:1;		// indicates user has initiated a rollback
   unsigned int Reserve:29;               // 
}UPDATE_FLAGS;


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////// ME FWU related Information that will be provided by discovery DLL /////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
// ME_FWU_INFO General information related to FW update
// Few basic rules:
// Do not delete member, allow add new member only to the end of this struct.
// The producer(Kernel) will only copy up to the size of the consumer StructSize. Consumer must set the StructSize.
// TBD each field need to initialize to invalid pattern? In the case that we could not get 
// the information. 
typedef struct  _ME_FWU_INFO
{
   unsigned int      StructSize;          // SizeOfThisStruct
   unsigned int      ApiVer;              // Version of this API  Major in upper 16 bits
   VERSION     FtpVer;              // QWORD Major(15:0), Minor(31:16), HotFix(47:32), 
                                    // Build#(63:48)
   VERSION     NftpVer;             // QWORD Major(15:0), Minor(31:16), HotFix(47:32), 
                                    // Build#(63:48)
   unsigned int      ChipsetVer;          // PCH version
   unsigned int      GlobalChipId;        // Global chip identification
   unsigned char	   SystemManufacturer[32]; // Ascii of char string 

   unsigned int      MebxFwuConfig;       // 0= Disable, 1 = enable , 2 = PW protected
   unsigned int      HwSku;				// MEFWCAPS_SKU   HW feature set or not
   unsigned int      FwSku;				// MEFWCAPS_SKU   FW feature set from 
                                    // SkuTable fuse or not fuse  
   unsigned int      LastFwUpdateStatus;  // Last FW update status
   unsigned int      DataFormatVer;       // Data format version Major(31:16), Minor (15:0). Only Major is used
   unsigned int      SvnVer;              // Security version number
   unsigned int      VcnVer;              // Version Control Number
                                    // This field is currently not used
/* Warning *********************************************************************/                                    
// Do not delete member, allow add new member only to the end of this struct.
/* Warning *********************************************************************/                                    
   VERSION     MebxVer;             // MEBX version 
   FWU_INFO_FLAGS  FwuInfoFlags;    // FWU information flags
   unsigned int	 PlatformAttributes;	    // ME_PLATFORM_TYPE Contains Platform Attributes: 
                                    // CpuType,platform type, superSku,etc. See ME_PLATFORM_TYPE
   OEM_UUID    OemId;               // Famous OEM_ID
   unsigned short      MeFwSize;            // Size of FW image in multiple of .5MB
   unsigned char       History[4];          // Keep track of version tree history
                                    // Minor0Predecessor, Minor1Predecessor, Minor2Predecessor, Minor3Predecessor
                                    // FWU will check to see if the update image has the same predecessor with the
                                    // one that is already in the flash before allow the update.
   unsigned int      CriticalHotfixDescriptor;  // Each bit signify a particular Critical Hot Fix
   unsigned int      FwuIFRAllowedRule;   // 1 Aloowed, 0 Disallowed
   FWU_RESTORE_POINT_INFO      LastRestorePointInfo; //Replace old unsigned int      Reserved[29]; 
   unsigned int      FwStatus1;           // Firmware status register 1, use for debugging
   unsigned int      FwStatus2;           // Firmware status register 2, use for debugging   
   unsigned int      Reserve1;            //                     // 
   unsigned short      NumSupportedIup;     // Number of IPUs actually supported, use this number to traverse IupEntry  
   PT_ATTRB    IupEntry [MAXIMUM_IPU_SUPPORTED];  

}ME_FWU_INFO;
C_ASSERT(sizeof(ME_FWU_INFO) == 448);


// Typedef for the commands serviced by the Fw Update service
typedef enum _FWU_HECI_MESSAGE_TYPE
{
   FWU_GET_VERSION = 0,
   FWU_GET_VERSION_REPLY,
   FWU_START,
   FWU_START_REPLY,
   FWU_DATA,
   FWU_DATA_REPLY,
   FWU_END,
   FWU_END_REPLY,
   FWU_GET_INFO,
   FWU_GET_INFO_REPLY,
   FWU_GET_FEATURE_STATE,
   FWU_GET_FEATURE_STATE_REPLY,
   FWU_GET_FEATURE_CAPABILITY,
   FWU_GET_FEATURE_CAPABILITY_REPLY,
   FWU_GET_PLATFORM_TYPE,
   FWU_GET_PLATFORM_TYPE_REPLY,
   FWU_VERIFY_OEMID,
   FWU_VERIFY_OEMID_REPLY,
   FWU_GET_OEMID,
   FWU_GET_OEMID_REPLY,
   FWU_IMAGE_COMPATABILITY_CHECK,
   FWU_IMAGE_COMPATABILITY_CHECK_REPLY,
   FWU_GET_UPDATE_DATA_EXTENSION,
   FWU_GET_UPDATE_DATA_EXTENSION_REPLY,
   FWU_GET_RESTORE_POINT_IMAGE,
   FWU_GET_RESTORE_POINT_IMAGE_REPLY,
   //FWU_GET_RECOVERY_MODE,
   //FWU_GET_RECOVERY_MODE_REPLY,
   FWU_GET_IPU_PT_ATTRB,
   FWU_GET_IPU_PT_ATTRB_REPLY,
   FWU_GET_FWU_INFO_STATUS,
   FWU_GET_FWU_INFO_STATUS_REPLY,
   GET_ME_FWU_INFO,
   GET_ME_FWU_INFO_REPLY,
   FWU_CONFIRM_LIVE_PING,
   FWU_CONFIRM_LIVE_PING_REPLY,
   FWU_VERIFY_PWD,
   FWU_VERIFY_PWD_REPLY,
   FWU_GET_RESTORE_POINT_IMAGE_DATA,
   FWU_GET_RESTORE_POINT_IMAGE_DATA_REPLY,
   FWU_INVALID_REPLY = 0xFF
} FWU_HECI_MESSAGE_TYPE;


/**
 * FWU_FLASH_IMAGE_START_MSG - start the update process
 *
 * @MessageType: FWU_FLASH_IMAGE_START_MSG
 */
typedef struct _FWU_FLASH_IMAGE_START_MSG_REPLY
{
   STATUS   Status;
   unsigned int   Resv[4];
}FWU_FLASH_IMAGE_START_MSG_REPLY;


/**
 * FWU_GET_VERSION_MSG - start the update process
 *
 * @MessageType: FWU_GET_VERSION_MSG
 */
// Struct definition below here //
typedef struct _FWU_GET_VERSION_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      Sku;       
   unsigned int      PCHVer;
   unsigned int      Vendor;
   unsigned int      LastFwUpdateStatus;
   unsigned int      HwSku;
   VERSION     CodeVersion;
   VERSION     AMTVersion;
   unsigned short      EnabledUpdateInterfaces;   // local, remote (LMS/LME) and secure update
   unsigned short      SvnInFlash;                // Security version of image that is already in flash
   unsigned int      DataFormatVersion;         // Upper 16 sig bits for Major version lower 16's for Minor Version
   unsigned int      LastUpdateResetType;       // Last successfull update partition reset type prior to reboot. After reboot, it should be zero
} FWU_GET_VERSION_MSG_REPLY;


/**
 * FWU_START_MSG - start the update process
 *
 * @MessageType: FWU_START_MSG
 */
typedef struct _FWU_START_MSG
{
   unsigned int   MessageType;     
   unsigned int   Length;           // Length of update image
   unsigned int   UpdtLength;		// Length of preupdate partition
   unsigned char    UpdateType;       // 0 Full update, 1 partial IPU pdate
   unsigned char    PassWordLength;   // Length of password not include NULL
   unsigned char    PassWordData[FWU_PWD_MAX_SIZE];  // Password data not include NULL byte
   unsigned int   IpuIdTobeUpdated; // Only for Partial FWU
   unsigned int   UpdateEnvironment;// 0 default to normal manufacturing use 
                              // 1 is for Emergency IFU update 
   UPDATE_FLAGS	UpdateFlags;	
   OEM_UUID OemId;
   unsigned int   Resv[4];
} FWU_START_MSG;


typedef struct _FWU_START_MSG_REPLY
{
   unsigned int   MessageType;
   STATUS   Status;
   unsigned int   Resv[4];

}FWU_START_MSG_REPLY;


/**
 * FWU_DATA_MSG - send data during the update process
 *
 * @MessageType: FWU_DATA_MSG
 */
 typedef struct _FWU_DATA_MSG
{
   unsigned int   MessageType;
   unsigned int   Length;
   unsigned char    Reserved[3];
   unsigned char    Data[1];
} FWU_DATA_MSG;


typedef struct _FWU_DATA_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status;
}FWU_DATA_MSG_REPLY;


/**
 * FWU_END_MSG - end the update process
 *
 * @MessageType: FWU_END_MSG
 */
typedef struct _FWU_END_MESSAGE
{
    unsigned int MessageType;
} FWU_END_MESSAGE;

typedef struct _FWU_END_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status; // 0 indicate success, else failure
   unsigned int ResetType; 
   unsigned int Resv[4];

}FWU_END_MSG_REPLY;


/**
 * FWU_GET_INFO_MSG - get info
 *
 * @MessageType: FWU_GET_INFO_MSG
 */
typedef struct _FWU_GET_INFO_MSG
{
   unsigned int MessageType;
} FWU_GET_INFO_MSG;

// Contains the data to be returned for GET_VERSION command
typedef struct _FWU_GET_INFO_MSG_REPLY{
   unsigned int          MessageType;
   unsigned int          Status;
   VERSION         MEBxVersion;
   unsigned int          FlashOverridePolicy;
   unsigned int          MangeabilityMode;
   unsigned int          BiosBootState;
   struct {
     unsigned int        CryptoFuse   :1;
     unsigned int        FlashProtection:1; // read from SPI driver
     unsigned int        Obsolete_FwOverrideQualifier:2;
     unsigned int        MeResetReason:2; // Reset.h
     unsigned int        Obsolete_FwOverrideCounter:8; //TO DO: change this in MeTypes.h to unsigned char
     unsigned int        reserved:18;
    }Fields;
   unsigned char          BiosVersion[20];

}FWU_GET_INFO_MSG_REPLY;


/**
 * FWU_GET_FEATURE_STATE_MSG - get info
 *
 * @MessageType: FWU_GET_FEATURE_STATE_MSG
 */
typedef struct _FWU_GET_FEATURE_STATE_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      FeatureState;       
} FWU_GET_FEATURE_STATE_MSG_REPLY;


/**
 * FWU_GET_PLATFORM_TYPE_MSG - get plat type
 *
 * @MessageType: FWU_GET_PLATFORM_TYPE_MSG
 */
typedef struct _FWU_GET_PLATFORM_TYPE_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      PlatformType;       
} FWU_GET_PLATFORM_TYPE_MSG_REPLY;


/**
 * FWU_VERIFY_OEMID_MSG - verify OEMID
 *
 * @MessageType: FWU_VERIFY_OEMID_MSG
 */
typedef struct _FWU_VERIFY_OEMID_MSG
{
   unsigned int  MessageType;
   OEM_UUID      OemId;
} FWU_VERIFY_OEMID_MSG;

typedef struct _FWU_VERIFY_OEMID_MSG_REPLY
{
   unsigned int  MessageType;
   unsigned int Status;
}FWU_VERIFY_OEMID_MSG_REPLY;


/**
 * FWU_GET_OEMID_MSG - verify OEMID
 *
 * @MessageType: FWU_GET_OEMID_MSG
 */
typedef struct _FWU_GET_OEMID_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS        Status;
   OEM_UUID      OemId;
} FWU_GET_OEMID_MSG_REPLY;


/**
 * FWU_IMAGE_COMPATABILITY_CHECK_MSG - verify image compatability
 *
 * @MessageType: FWU_IMAGE_COMPATABILITY_CHECK_MSG
 */
typedef struct _FWU_IMAGE_COMPATABILITY_CHECK_MSG
{
   unsigned int   MessageType;
   unsigned int   ManifestLength;      // Manifest Len
   unsigned char    Reserved[3];
   unsigned char    ManifestBuffer[1];   // At least one element 
                                 // otherwise compiling error when use WATCOM compiler
}FWU_IMAGE_COMPATABILITY_CHECK_MSG;



typedef struct _FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS      Status;  // 0 is OK for update, else failures
                        // Possible error code 
                        // STATUS_UPDATE_READ_FILE_FAILURE
                        // STATUS_UPDATE_FW_VERSION_MISMATCH
                        // STATUS_UPDATE_IMAGE_INVALID
                        // STATUS_UPDATE_FLASH_CODE_PARTITION_INVALID
                        // STATUS_UPDATE_IMAGE_VERSION_HISTORY_CHECK_FAILURE
                        // STATUS_UPDATE_IMAGE_BLACKLISTED
}FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY;


/**
 * FWU_GET_UPDATE_DATA_EXTENSION_MSG - verify image compatability
 *
 * @MessageType: FWU_GET_UPDATE_DATA_EXTENSION_MSG
 */
typedef struct _FWU_GET_UPDATE_DATA_EXTENSION_MSG
{
    unsigned int MessageType;
} FWU_GET_UPDATE_DATA_EXTENSION_MSG;

typedef struct _FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY
{
   unsigned int       MessageType;
   STATUS       Status;          // 0 for success, other failure and the info is invalid
   unsigned char        History[4];      // Minor0Predecessor, Minor1Predecessor, Minor2Predecessor, Minor3Predecessor
   unsigned int       CriticalHotfixDescriptor;
   BLACK_LIST_ENTRY     BlackList[BLACK_LIST_ENTRY_MAX];
}FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY;


/**
 * FWU_GET_RESTORE_POINT_IMAGE_MESSAGE - get restore point image
 *
 * @MessageType: FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
 */
typedef struct _FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
{
	unsigned int MessageType;
} FWU_GET_RESTORE_POINT_IMAGE_MESSAGE;

typedef struct _FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS  Status;
   unsigned int  RestorePointImageSize; // Size of image is in Bytes
   unsigned int  RestorePointImage[1];
}FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY;


/**
 * FWU_GET_RESTORE_POINT_IMAGE_MESSAGE - get restore point image
 *
 * @MessageType: FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
 */
typedef struct _FWU_GET_RESTORE_POINT_IMAGE_DATA_MESSAGE
{
	unsigned int MessageType;
} FWU_GET_RESTORE_POINT_IMAGE_DATA_MESSAGE;

typedef struct _FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS  Status;
   unsigned int RestorePointImageOffset;
   unsigned int  RestorePointImageDataLength; // Size of image is in Bytes
   unsigned int  RestorePointImage[1];
}FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY;


/**
 * FWU_GET_IPU_PT_ATTRB_MSG - get info status
 *
 * @MessageType: FWU_GET_IPU_PT_ATTRB_MSG
 */
typedef struct _FWU_GET_IPU_PT_ATTRB_MSG
{
   unsigned int   MessageType;
   unsigned int   UpdateType;
} FWU_GET_IPU_PT_ATTRB_MSG;

typedef struct _FWU_GET_IPU_PT_ATTRB_MSG_REPLY
{
   unsigned int   MessageType;      // Internal FWU tool use only
   STATUS   Status;           // Internal FWU tool use only
   VERSION  FtpFwVer;         // FW version in Fault Tolerance Partition. 
                              // This might be used for diagnostic or debug.
   unsigned int   SizeoOfPtAttrib;  // Size in bytes. Simply is the sizeof (PT_ATTRB structure)
   unsigned int   NumOfPartition;   // Number of partition actually return in this reply message
   PT_ATTRB  PtAttribute[MAXIMUM_IPU_SUPPORTED];
   unsigned int   Resv[4];
}FWU_GET_IPU_PT_ATTRB_MSG_REPLY;


/**
 * FWU_GET_FWU_INFO_STATUS_MSG - get info status
 *
 * @MessageType: FWU_GET_FWU_INFO_STATUS_MSG
 */
typedef struct _FWU_GET_FWU_INFO_STATUS_MSG
{
   unsigned int   MessageType;
   unsigned int   InfoParm;         // Not used 
   unsigned int   Resv[4];
}FWU_GET_FWU_INFO_STATUS_MSG;

typedef struct _FWU_GET_FWU_INFO_STATUS_MSG_REPLY
{
   unsigned int   MessageType;
   STATUS   Status;
   FWU_INFO_FLAGS   Flags;
   unsigned int   Resv[4];
}FWU_GET_FWU_INFO_STATUS_MSG_REPLY;


/**
 * ME_FWU_INFO_MSG - get ME firmware update info message
 *
 * @MessageType: ME_FWU_INFO_MSG
 */
typedef struct _ME_FWU_INFO_MSG
{
	unsigned int MessageType;
	unsigned int MessageParams[2]; //Currently not used
}ME_FWU_INFO_MSG;

typedef struct _ME_FWU_INFO_MSG_REPLY
{
	unsigned int				MessageType;
	unsigned int				Status; // 0 = success, else failure
	ME_FWU_INFO			MeFwuInfo;
}ME_FWU_INFO_MSG_REPLY;

/**
 * FWU_CONFIRM_LIVE_PING_MSG - confirm live ping
 *
 * @MessageType: FWU_CONFIRM_LIVE_PING_MSG
 */
typedef struct _FWU_CONFIRM_LIVE_PING_MSG
{
   unsigned int  MessageType;
   unsigned int  Reserve[4];
} FWU_CONFIRM_LIVE_PING_MSG;

typedef struct _FWU_CONFIRM_LIVE_PING_MSG_REPLY
{
   unsigned int  MessageType;
   unsigned int  Status;    // Always STATUS_SUCCESS = 0
   unsigned int  Reserve[4];
}FWU_CONFIRM_LIVE_PING_MSG_REPLY;


/**
 * FWU_VERIFY_PWD_MSG - confirm live ping
 *
 * @MessageType: FWU_VERIFY_PWD_MSG
 */
typedef struct _FWU_VERIFY_PWD_MSG
{
	unsigned int MessageType;
	unsigned char PasswordLength;
	unsigned char PasswordData[FWU_PWD_MAX_SIZE];
}FWU_VERIFY_PWD_MSG;

typedef struct _FWU_VERIFY_PWD_MSG_REPLY	
{
	unsigned int MessageType;
	unsigned int Status;
}FWU_VERIFY_PWD_MSG_REPLY;


/**
 * FWU_INVALID_MSG - confirm live ping
 *
 * @MessageType: FWU_INVALID_MSG
 */
typedef struct _FWU_INVALID_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status;
}FWU_INVALID_MSG_REPLY;


//NOTE: WE ARE VERY CLOSE TO MAXIMUM HECI MESSAGE BUFFER SIZE
typedef struct  _FWU_HECI_MSG
{
   union{
      unsigned int  MessageType;
 
      FWU_GET_VERSION_MSG_REPLY        VersionReply;
      FWU_START_MSG                    Start;
      FWU_START_MSG_REPLY              StartReply;
      FWU_DATA_MSG                     Data;
      FWU_DATA_MSG_REPLY               DataReply;
      FWU_END_MSG_REPLY                EndReply;
      FWU_GET_INFO_MSG_REPLY           InfoReply;
      FWU_GET_FEATURE_STATE_MSG_REPLY  FeatureStateReply;
      FWU_GET_PLATFORM_TYPE_MSG_REPLY  PlatformTypeReply;
      FWU_VERIFY_OEMID_MSG             VerifyOemId;
      FWU_VERIFY_OEMID_MSG_REPLY       VerifyOemIdReply;
      FWU_GET_OEMID_MSG_REPLY          GetOemIdReply;
      FWU_IMAGE_COMPATABILITY_CHECK_MSG   ImageCheck;
      FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY         ImageCheckReply;
      FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY         GetUpdateDataExtReply;
      FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY           GetRestorePointImageReply;
	  FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY	GetRestorePointImageDataReply;
      //FWU_GET_RECOVERY_MODE_MSG                       GetRecoveryMode; 
      //FWU_GET_RECOVERY_MODE_MSG_REPLY                 GetRecoveryModeReply; 
      FWU_GET_IPU_PT_ATTRB_MSG                        GetIpuPtAttrb; 
      FWU_GET_IPU_PT_ATTRB_MSG_REPLY                  GetIpuPtAttrbReply;
      FWU_GET_FWU_INFO_STATUS_MSG                     GetFwuInfoStatusMsg;
      FWU_GET_FWU_INFO_STATUS_MSG_REPLY               GetFwuInfoStatusMsgReply;
	  ME_FWU_INFO_MSG_REPLY					          GetMeInfoMsgReply;
      FWU_CONFIRM_LIVE_PING_MSG                       ConfirmLivePingMsg;
      FWU_CONFIRM_LIVE_PING_MSG_REPLY                 ConfirmLivePingMsgReply;
      FWU_VERIFY_PWD_MSG 			VerifyPwd;
      FWU_VERIFY_PWD_MSG_REPLY			VerifyPwdReply;
      FWU_INVALID_MSG_REPLY            InvalidMsgReply;

   }MessageData;
}FWU_HECI_MSG;

// ***************************************
/* HMRFPO Message Data Structures       */
// ***************************************

//HMRFPO ENABLE REQ
typedef struct _FWUPDATE_HMRFPO_ENABLE_DATA //unlock
{
   unsigned long long                  Nonce;   //For minisku/BIOS message compatibility
} FWUPDATE_HMRFPO_ENABLE_DATA;

typedef struct _FWUPDATE_HMRFPO_ENABLE
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_ENABLE_DATA         Data;    //For minisku/BIOS message compatibility
} FWUPDATE_HMRFPO_ENABLE;


//HMRFPO ENABLE ACK
typedef struct _FWUPDATE_HMRFPO_ENABLE_ACK_DATA
{
   unsigned int                              FactoryDefaultBase;     //For minisku/BIOS message compatibility
   unsigned int                              FactoryDefaultLimit;    //For minisku/BIOS message compatibility
   unsigned char                               HMRFPO_EN_Status;
   unsigned char                               Rsvd[3];
} FWUPDATE_HMRFPO_ENABLE_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_ENABLE_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_ENABLE_ACK_DATA     Data;
} FWUPDATE_HMRFPO_ENABLE_ACK;


//HMRFPO LOCK REQ
typedef struct _FWUPDATE_HMRFPO_LOCK
{
   mkhi_message_header_t                 Header;
} FWUPDATE_HMRFPO_LOCK;


//HMRFPO LOCK ACK
typedef struct _FWUPDATE_HMRFPO_LOCK_ACK_DATA
{
   unsigned long long                              Nonce;
   unsigned int                              FactoryDefaultBase;  //For minisku/BIOS message compatibility
   unsigned int                              FactoryDefaultLimit; //For minisku/BIOS message compatibility
   unsigned char                               HMRFPO_LOCK_Status;
   unsigned char                               Rsvd[3];
} FWUPDATE_HMRFPO_LOCK_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_LOCK_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_LOCK_ACK_DATA       Data;
} FWUPDATE_HMRFPO_LOCK_ACK;

//HMRFPO GETSTATUS REQ
typedef struct _FWUPDATE_HMRFPO_GETSTATUS
{
   mkhi_message_header_t                    Header;
} FWUPDATE_HMRFPO_GETSTATUS;


//HMRFPO GETSTATUS ACK
typedef struct _FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA
{
   unsigned char                                  HMRFPO_State;
   unsigned char                                  Rsvd[3];
} FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_GETSTATUS_ACK
{
   mkhi_message_header_t                    Header;
   FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA     Data;
} FWUPDATE_HMRFPO_GETSTATUS_ACK;

/*
//HMRFPO DISABLE REQ
typedef struct _FWUPDATE_HMRFPO_DISABLE
{
   mkhi_message_header_t           Header;
} FWUPDATE_HMRFPO_DISABLE;

typedef struct _MKHI_FWUPDATE_HMRFPO_DISABLE
{
   HECI_MESSAGE_HEADER           Header;
   FWUPDATE_HMRFPO_DISABLE       Msg;
} MKHI_FWUPDATE_HMRFPO_DISABLE;

//HMRFPO DISABLE ACK
typedef struct _FWUPDATE_HMRFPO_DISABLE_ACK_DATA
{
   unsigned char                         HMRFPO_DIS_Status;
   unsigned char                         Reserved[3];   //To conform to CBM_TEMPLATE in BUP 
                                                //so sizeof(FWUPDATE_HMRFPO_DISABLE_ACK_DATA) == UINT32
} FWUPDATE_HMRFPO_DISABLE_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_DISABLE_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_DISABLE_ACK_DATA    Data;
} FWUPDATE_HMRFPO_DISABLE_ACK;

// FWUPDATE_QUERY_UPDATE_STATUS
typedef struct _FWUPDATE_QUERY_UPDATE_STATUS
{
   mkhi_message_header_t                    Header;
} FWUPDATE_QUERY_UPDATE_STATUS;


//FWUPDATE_QUERY_UPDATE_STATUS_ACK
typedef struct _FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA
{
   unsigned int                                 PercentComplete;
   unsigned int                                 CurrentStage;         // Current update Stage
   unsigned int                                 TotalStages;          // Total number of update stages
   unsigned int                                 LastUpdateStatus;     // Last FW update status                                                      
} FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA;

typedef struct _FWUPDATE_QUERY_UPDATE_STATUS_ACK
{
   mkhi_message_header_t                    Header;   // Header.Result = 0 indicate in progress
                                                    // Header.Result = 1 Complete the update
                                                    // Header.Result = 2 Error during the update
   FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA    QueryAckData;
   unsigned int ResetType;        // Partition reset type
   FWU_INFO_FLAGS   Flags;  // See FWU_INFO_FLAGS
} FWUPDATE_QUERY_UPDATE_STATUS_ACK;
*/

// FWUPDATE_FORCE_SAFE_BOOT_CMD
typedef struct _FWUPDATE_FORCE_SAFE_BOOT_MSG
{
   mkhi_message_header_t                    Header;
} FWUPDATE_FORCE_SAFE_BOOT_MSG;

typedef struct _FWUPDATE_FORCE_SAFE_BOOT_MSG_ACK
{
   mkhi_message_header_t              Header;   // Header.Result = 0 indicate success else failure
   unsigned int                           Data;                   
} FWUPDATE_FORCE_SAFE_BOOT_MSG_ACK;


// FWU_GET_IMAGE_FW_VERSION
typedef struct _FWU_GET_IMAGE_FW_VERSION_Request
{
   mkhi_message_header_t    Header;
} FWU_GET_IMAGE_FW_VERSION_Request;

typedef struct _FWU_GET_IMAGE_FW_VERSION_Response
{
    mkhi_message_header_t   Header;
    uint32_t                NumOfPartition; // Number of partition actually returned in this reply message
    PT_ATTRB                PtAttribute[MAXIMUM_IPU_SUPPORTED]; // IPU attributes entries
} FWU_GET_IMAGE_FW_VERSION_Response;


#pragma pack()


#endif  // _FWU_COMMON_H



